<div class="container">
<?php
if( ! isset( $optional_login ) )
{
	echo '<h1>Login</h1>';
}

if( ! isset( $on_hold_message ) )
{
	if( isset( $login_error_mesg ) )
	{
		echo '
			<div class="feedback error_message">
				<p class="feedback_header">
					Login Error: Invalid Username, Email Address, or Password.
				</p>
				<p style="margin:.4em 0 0 0;">
					Username, email address and password are all case sensitive.
				</p>
			</div>
		';
	}

	if( $this->input->get('logout') )
	{
		echo '
			<div class="feedback confirmation">
				<p class="feedback_header">
					You have successfully logged out.
				</p>
			</div>
		';
	}

?>


<div class="row">
	<div class="col-md-4 col-md-offset-4">
		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title">Login via site</h3>
			</div>
			<div class="panel-body">
				<?php echo form_open( '', array( 'class' => '', 'style' => '','role'=>'form' ) ); ?>
					<fieldset>
						<div class="form-group">
							<input class="form-control" placeholder="E-mail" name="login_string" type="text" autocomplete="off">
						</div>
						<div class="form-group">
							<input class="form-control" placeholder="Password" name="login_pass" type="password" value=""  autocomplete="off" maxlength="<?php echo MAX_CHARS_4_PASSWORD; ?>">
						</div>
						<?php
							if( config_item('allow_remember_me') )
							{
						?>
						<div class="checkbox">
							<label>
								<input name="remember_me" type="checkbox" value="Remember Me">
								Remember Me </label>
						</div>
						<?php
							}
						?>
						<input class="btn btn-lg btn-success btn-block" type="submit" value="Login">
					</fieldset>
					<p>
						<a href="<?php echo secure_site_url('user/recover'); ?>">
							Can't access your account?
						</a>
					</p>
				</form>
				<hr/>
				<center>
					<h4>OR</h4>
				</center>
				<input class="btn btn-lg btn-facebook btn-block" type="submit" value="Login via facebook">
			</div>
		</div>
	</div>
</div>

<?php

	}
	else
	{
		// EXCESSIVE LOGIN ATTEMPTS ERROR MESSAGE
		echo '
			<div class="feedback error_message">
				<p class="feedback_header">
					Excessive Login Attempts
				</p>
				<p style="margin:.4em 0 0 0;">
					You have exceeded the maximum number of failed login<br />
					attempts that the ' . WEBSITE_NAME . ' website will allow.
				<p>
				<p style="margin:.4em 0 0 0;">
					Your access to login and account recovery has been blocked for ' . ( (int) config_item('seconds_on_hold') / 60 ) . ' minutes.
				</p>
				<p style="margin:.4em 0 0 0;">
					Please use the ' . secure_anchor('user/recover','Account Recovery') . ' after ' . ( (int) config_item('seconds_on_hold') / 60 ) . ' minutes has passed,<br />
					or ' . secure_anchor('contact','Contact') . ' ' . WEBSITE_NAME . '  if you require assistance gaining access to your account.
				</p>
			</div>
		';
	}
?>
</div>